<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->user_id) && isset($data->name) && isset($data->email)) {
    $user_id = (int)$data->user_id;
    $name = trim($data->name);
    $email = trim($data->email);

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(["success" => false, "message" => "Invalid email format"]);
        exit;
    }
    
    try {
        if (isset($data->password) && trim($data->password) !== "") {
            // If a new password is provided, hash it and update it along with name and email
            $password = password_hash(trim($data->password), PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE users SET name = :name, email = :email, password = :password WHERE id = :id");
            $stmt->execute([
                'name' => $name,
                'email' => $email,
                'password' => $password,
                'id' => $user_id
            ]);
        } else {
            // Otherwise, update only name and email
            $stmt = $pdo->prepare("UPDATE users SET name = :name, email = :email WHERE id = :id");
            $stmt->execute([
                'name' => $name,
                'email' => $email,
                'id' => $user_id
            ]);
        }
        echo json_encode(["success" => true, "message" => "Profile updated successfully"]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
}
?>
