<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

$response = [
    "success" => false,
    "message" => ""
];

// Check required fields: first_name, last_name, email, password must be provided
if (isset($data->first_name) && isset($data->last_name) && isset($data->email) && isset($data->password)) {
    $first_name = trim($data->first_name);
    $last_name  = trim($data->last_name);
    $email      = trim($data->email);
    $password   = trim($data->password);
    
    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(["success" => false, "message" => "Invalid email format"]);
        exit;
    }
    
    // Check if user with this email already exists
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->rowCount() > 0) {
        echo json_encode(["success" => false, "message" => "Email already registered"]);
        exit;
    }
    
    // Determine user role based on adminCode (optional)
    $secretAdminCode = "SUPERADMIN2025";  // In production, store this securely.
    $role = "user"; // default role
    if (isset($data->adminCode) && trim($data->adminCode) === $secretAdminCode) {
        $role = "admin";
    }
    
    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    
    try {
        // Insert the new user
        $insertStmt = $pdo->prepare("INSERT INTO users (first_name, last_name, email, password, role) VALUES (:first_name, :last_name, :email, :password, :role)");
        $insertStmt->execute([
            'first_name' => $first_name,
            'last_name'  => $last_name,
            'email'      => $email,
            'password'   => $hashedPassword,
            'role'       => $role
        ]);
        
        // Retrieve the newly created user's details
        $lastId = $pdo->lastInsertId();
        $userStmt = $pdo->prepare("SELECT id, first_name, last_name, email, role FROM users WHERE id = :id LIMIT 1");
        $userStmt->execute(['id' => $lastId]);
        $newUser = $userStmt->fetch(PDO::FETCH_ASSOC);
        
        $response['success'] = true;
        $response['message'] = "User registered successfully";
        $response['user'] = $newUser;
    } catch (PDOException $e) {
        $response['message'] = $e->getMessage();
    }
} else {
    $response['message'] = "Missing required fields";
}

echo json_encode($response);
?>
