<?php
// get_all_events.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db_config.php'; // your DB connection

try {
    $stmt = $pdo->query("SELECT id, title, description, event_date, location FROM events");
    $results = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Convert your 'event_date' to ISO 8601
        // If stored as 'YYYY-MM-DD HH:MM:SS', do:
        $isoDate = date("c", strtotime($row["event_date"]));

        $results[] = [
            "id" => $row["id"],
            "title" => $row["title"],
            "description" => $row["description"],
            "event_date" => $isoDate,
            "location" => $row["location"]
        ];
    }
    echo json_encode(["success" => true, "events" => $results]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => $e->getMessage()]);
}
