<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"), true);
$response = ["success" => false, "message" => ""];

if (isset($data['user_id']) && isset($data['event_id'])) {
    $user_id = (int)$data['user_id'];
    $event_id = (int)$data['event_id'];

    try {
        // Check if the user is already registered for the event
        $checkStmt = $pdo->prepare("SELECT id FROM registrations WHERE user_id = :user_id AND event_id = :event_id LIMIT 1");
        $checkStmt->execute(['user_id' => $user_id, 'event_id' => $event_id]);
        if ($checkStmt->rowCount() > 0) {
            $response['message'] = "You are already registered for this event.";
            echo json_encode($response);
            exit;
        }
        
        // Insert new registration without created_at
        $insertStmt = $pdo->prepare("INSERT INTO registrations (user_id, event_id) VALUES (:user_id, :event_id)");
        if ($insertStmt->execute(['user_id' => $user_id, 'event_id' => $event_id])) {
            $response['success'] = true;
            $response['message'] = "Event booked successfully!";
        } else {
            $response['message'] = "Booking failed. Please try again.";
        }
    } catch (PDOException $e) {
        $response['message'] = "Database error: " . $e->getMessage();
    }
} else {
    $response['message'] = "Missing user_id or event_id.";
}

echo json_encode($response);
?>
