<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->event_id) && isset($data->user_id) && isset($data->rating)) {
    $event_id = (int)$data->event_id;
    $user_id = (int)$data->user_id;
    $rating = (int)$data->rating;
    $comment = isset($data->comment) ? trim($data->comment) : null;
    
    // Validate rating is between 1 and 5
    if ($rating < 1 || $rating > 5) {
        echo json_encode(["success" => false, "message" => "Rating must be between 1 and 5"]);
        exit;
    }
    
    try {
        // Insert a new rating, or update the existing one if the same user already rated this event
        $stmt = $pdo->prepare("
            INSERT INTO event_ratings (event_id, user_id, rating, comment)
            VALUES (:event_id, :user_id, :rating, :comment)
            ON DUPLICATE KEY UPDATE rating = :rating, comment = :comment
        ");
        $stmt->execute([
            'event_id' => $event_id,
            'user_id'  => $user_id,
            'rating'   => $rating,
            'comment'  => $comment
        ]);
        
        echo json_encode([
            "success" => true, 
            "message" => "Rating submitted successfully. (Submitting again will update your previous feedback.)"
        ]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
}
?>
