<?php
// reset_password.php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

require_once 'db_config.php'; // your DB connection

$input = json_decode(file_get_contents('php://input'), true);
$token = $input['token'] ?? '';
$newPassword = $input['password'] ?? '';

$response = [
  'success' => false,
  'message' => ''
];

if (empty($token) || empty($newPassword)) {
  $response['message'] = "Missing token or password.";
  echo json_encode($response);
  exit;
}

// Validate token
$stmt = $pdo->prepare("SELECT user_id FROM password_resets 
                       WHERE token = :token 
                       AND expires_at > NOW() 
                       LIMIT 1");
$stmt->execute([':token' => $token]);
$reset = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$reset) {
  $response['message'] = "Invalid or expired token.";
  echo json_encode($response);
  exit;
}

$user_id = $reset['user_id'];

// Update user's password
// Hash the password using password_hash
$hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

$updateStmt = $pdo->prepare("UPDATE users SET password = :pwd WHERE id = :id LIMIT 1");
$updateStmt->execute([':pwd' => $hashedPassword, ':id' => $user_id]);

// Remove the token to prevent reuse
$delStmt = $pdo->prepare("DELETE FROM password_resets WHERE token = :token");
$delStmt->execute([':token' => $token]);

$response['success'] = true;
$response['message'] = "Password updated successfully! You can now log in.";
echo json_encode($response);
