<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->email) && isset($data->password)) {
    // Convert email to lowercase for case-insensitive matching
    $email = strtolower(trim($data->email));
    $password = trim($data->password);
    
    // Use CONCAT to combine first_name and last_name into a single "name" field
    $stmt = $pdo->prepare("SELECT id, CONCAT(first_name, ' ', last_name) AS name, first_name, last_name, email, role, password FROM users WHERE LOWER(email) = :email LIMIT 1");
    $stmt->execute(['email' => $email]);
    
    if ($stmt->rowCount() === 1) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        if (password_verify($password, $user['password'])) {
            echo json_encode([
                "success" => true,
                "message" => "Login successful",
                "user" => [
                    "id"         => $user['id'],
                    "name"       => $user['name'],
                    "first_name" => $user['first_name'],
                    "last_name"  => $user['last_name'],
                    "email"      => $user['email'],
                    "role"       => $user['role']
                ]
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "Incorrect password"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "User not found"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing email or password"]);
}
?>
