<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

if (isset($_GET['id'])) {
    // -------------------------------
    // SINGLE EVENT MODE (with rating info)
    // -------------------------------
    $event_id = (int) $_GET['id'];
    try {
        $stmt = $pdo->prepare("SELECT * FROM events WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $event_id]);
        if ($stmt->rowCount() === 1) {
            $event = $stmt->fetch(PDO::FETCH_ASSOC);

            // Fetch average rating
            $ratingStmt = $pdo->prepare("SELECT AVG(rating) as avg_rating FROM event_ratings WHERE event_id = :event_id");
            $ratingStmt->execute(['event_id' => $event_id]);
            $ratingData = $ratingStmt->fetch(PDO::FETCH_ASSOC);
            $avg_rating = $ratingData['avg_rating'] ? round($ratingData['avg_rating'], 2) : null;

            // Fetch comments
            $commentsStmt = $pdo->prepare("SELECT er.rating, er.comment, er.created_at, u.name as user_name FROM event_ratings er JOIN users u ON er.user_id = u.id WHERE er.event_id = :event_id ORDER BY er.created_at DESC");
            $commentsStmt->execute(['event_id' => $event_id]);
            $comments = $commentsStmt->fetchAll(PDO::FETCH_ASSOC);

            echo json_encode([
                "success" => true,
                "event" => $event,
                "avg_rating" => $avg_rating,
                "comments" => $comments
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "Event not found"]);
        }
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
} elseif (isset($_GET['all']) && $_GET['all'] === "1") {
    // -------------------------------
    // ADMIN/ALL EVENTS MODE: Return ALL events (no pagination)
    // -------------------------------
    try {
        $stmt = $pdo->prepare("SELECT * FROM events ORDER BY event_date ASC");
        $stmt->execute();
        $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode([
            "success" => true,
            "events" => $events,
            "total" => count($events)
        ]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
} else {
    // -------------------------------
    // PAGINATION MODE: 8 events per page
    // -------------------------------
    $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
    if ($page < 1) {
        $page = 1;
    }
    $limit = 8;
    $offset = ($page - 1) * $limit;
    try {
        $countStmt = $pdo->query("SELECT COUNT(*) AS total FROM events");
        $countResult = $countStmt->fetch(PDO::FETCH_ASSOC);
        $totalEvents = (int)$countResult['total'];
        $totalPages = ceil($totalEvents / $limit);
        $stmt = $pdo->prepare("SELECT * FROM events ORDER BY event_date ASC LIMIT :limit OFFSET :offset");
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
        $stmt->execute();
        $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode([
            "success" => true,
            "events" => $events,
            "currentPage" => $page,
            "totalPages" => $totalPages
        ]);
    } catch (PDOException $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
}
?>
