<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

try {
    // Get total number of events
    $stmt = $pdo->query("SELECT COUNT(*) AS total_events FROM events");
    $totalEvents = (int)$stmt->fetch(PDO::FETCH_ASSOC)['total_events'];

    // Get total number of registrations
    $stmt = $pdo->query("SELECT COUNT(*) AS total_registrations FROM registrations");
    $totalRegistrations = (int)$stmt->fetch(PDO::FETCH_ASSOC)['total_registrations'];

    // Get overall average rating (across all events)
    $stmt = $pdo->query("SELECT AVG(rating) AS avg_rating FROM event_ratings");
    $avgRating = $stmt->fetch(PDO::FETCH_ASSOC)['avg_rating'];
    if ($avgRating !== null) {
        $avgRating = round($avgRating, 2);
    }

    echo json_encode([
        "success" => true,
        "totalEvents" => $totalEvents,
        "totalRegistrations" => $totalRegistrations,
        "avgRating" => $avgRating
    ]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => $e->getMessage()]);
}
?>
