<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once 'db_config.php';

$data = json_decode(file_get_contents("php://input"));

if (isset($data->title) && isset($data->description) && isset($data->event_date)) {
    $title = trim($data->title);
    $description = trim($data->description);
    $event_date = trim($data->event_date);
    $location = isset($data->location) ? trim($data->location) : null;
    $image = isset($data->image) ? trim($data->image) : null;
    $organizer = isset($data->organizer) ? trim($data->organizer) : null;
    $contact_email = isset($data->contact_email) ? trim($data->contact_email) : null;
    $image2 = isset($data->image2) ? trim($data->image2) : null;
    
    try {
        $stmt = $pdo->prepare("
            INSERT INTO events (title, description, event_date, location, image, organizer, contact_email, image2)
            VALUES (:title, :description, :event_date, :location, :image, :organizer, :contact_email, :image2)
        ");
        $stmt->execute([
            'title'         => $title,
            'description'   => $description,
            'event_date'    => $event_date,
            'location'      => $location,
            'image'         => $image,
            'organizer'     => $organizer,
            'contact_email' => $contact_email,
            'image2'        => $image2
        ]);
        echo json_encode(["success" => true, "message" => "Event created successfully"]);
    } catch(PDOException $e) {
        echo json_encode(["success" => false, "message" => "Error: " . $e->getMessage()]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
}
?>
